/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBGlobalIsotope = Object.create(STBModule.prototype);

STBGlobalIsotope.name = "GlobalIsotope & SameHeight";
STBGlobalIsotope.initPlugin = function () {
    try {

        var getHashFilter = function () {
                // get filter=filterName
                var matches = location.hash.match(/p=([^&]+)/i),
                    hashFilter = matches && matches[1];

                return hashFilter && decodeURIComponent(hashFilter);
            },
            hashFilter = getHashFilter(),
            realFilter = "";


		//alter the direction of the isotope when rtl
        if (jQuery("html").attr("dir") == "rtl") {
//			$.Isotope.prototype._positionAbs = function( x, y ) {
//			  return { right: x, top: y };
//			};
            
        }


        var isotopeFilters = jQuery('.isotope-filter:not(.__done)');

        if (isotopeFilters.length > 0) {

			isotopeFilters.each(function() {
				var isotopeFilter = jQuery(this);

				var isotopeFilterA = isotopeFilter.find('a');

				if (hashFilter) {
					//get the real filter
					var parseElemA = function () {

						var obj = jQuery(this),
							parent = obj.parent();

						if (obj.text() == hashFilter) {
							realFilter = obj.attr("data-filter");
							parent.addClass("active");
						} else {
							parent.removeClass("active");
						}
					};

					isotopeFilterA.each(parseElemA);
				}

				var parseFilter = function (e) {

					e.preventDefault();

					var obj = jQuery(this),
						filterAttr = obj.attr('data-filter'),
						filterText = obj.text(),
						parent = obj.attr("data-parent");

					jQuery(parent).isotope({
						filter: filterAttr
					});

					isotopeFilter.find('a[data-filter]').parent().removeClass("active");
					obj.parent().addClass("active");

					if (!parent.hasClass("isotope-nohash"))	{
						setTimeout(function () {
							if (filterAttr == "*") {
								location.hash = "";
							} else {
								location.hash = 'p=' + encodeURIComponent(filterText);
							}
						}, 1500);
					}
				};

				isotopeFilter.on('click', 'a[data-filter]', parseFilter);
				isotopeFilter.addClass("__done");
			});
        }


        // filter isotope
        var grid = jQuery('.same-height:not(.__done), .isotope-container:not(.__done)');


        if (grid.length > 0) {


			grid.each(function() {
				var el = jQuery(this);
	

				jQuery(this).imagesLoaded(function(result) {

					//check if is inside a carousel 
					var carousel = el.closest(".owl-carousel"),
						row = true;

					if (carousel.length> 0){
						row = false;
					}

					if (el.hasClass("same-height")) {
						var elements = el.find(".isotope-element > *");
						if (elements.length) {
							elements.matchHeight({ byRow : row}); 
						}
					}

					if (el.hasClass("isotope-container")) {

						var opt = {
							itemSelector: '.isotope-element',
							filter: realFilter,
							percentPosition: true
						};

						if (el.find('.grid-sizer').length > 0) {
							var n = {
								masonry: {
									columnWidth: '.grid-sizer'
								}
							};

							jQuery.extend(opt, n);
						}

						el.isotope(opt);

					}

				});
			});

			grid.addClass("__done");
		}
			

    } catch (e) {
        getStack(0, e);
    }
}


STBGlobalIsotope.runOnReady = function() {
	STBGlobalIsotope.initPlugin();
}


STBGlobalIsotope.runOnContentUpdate = function() {
	STBGlobalIsotope.initPlugin();
}

site.registerModule(STBGlobalIsotope);